SuperStrict

' Example 1: Basic Speech
' Demonstrates: InitSpeech(), SpeakText(), CleanupSpeech()

Framework BRL.StandardIO

' Import the BlitzSpeech .lib file
' Note: You will still have to ship the BlitzSpeech.DLL
' with your executable built.
Import "-L."
Import "-lBlitzSpeech"

' Set up the constants and external functions
Include "BlitzSpeechH.bmx"

Print "BlitzSpeech - Basic Speech Example"

Print ""

' Initialize speech
If InitSpeech() = SP_INIT_SUCCESS Then
    Print "Speech initialized successfully!"
    Print ""
    
    ' Speak some text
    Print "Speaking: 'Hello, this is BlitzSpeech!'"
    SpeakText("Hello, this is BlitzSpeech!")
    Print ""
    
    Print "Speaking: 'I can say anything you want.'"
    SpeakText("I can say anything you want.")
    Print ""
    
    Print "Speaking: 'This is a simple text-to-speech example.'"
    SpeakText("This is a simple text-to-speech example.")
    Print ""
    
    ' Cleanup
    Print "Cleaning up..."
    CleanupSpeech()
    Print "Done!"
Else
    Print "Failed to initialize speech!"
EndIf
